$(document).ready(function() {
	
	var clipboard = new ClipboardJS('.btn-copy');
	
	$('.menu-select-mob').change(function() {
	    var menu_page = $(this).val();
	    
	    if(menu_page != "0") {
		    window.location = menu_page;
	    }
	});
	
	$(".menu-item").click(function(e) {
		
		e.preventDefault();
		
		window.location = $(this).attr("data-url");
		
	});
	
	clipboard.on('success', function(e) {
	    
	    $(".btn-copy").html("Copied!").prop("disabled", true);
	
	    e.clearSelection();
	});
	
	// Build the random questions array
	var random_questions = ["Am I wearing socks right now?",
							"Am I awesome ?",
							"Am I sassy?",
							"Do I wear long or short socks usually?",
							"Which did I not get for Christmas last year?",
							"Which of the following have I never eaten?",
							"How much wood could a wood-chuck chuck?",
							"What is my favorite color?",
							"What is my favorite sport?",
							"What is my favorite food?",
							"What is my favorite animal?",
							"What is my favorite team?",
							"What is my favorite number?",
							"What is my favorite subject in school?",
							"What is my favorite band?",
							"What is my birthday?",
							"How old am I?",
							"Am I left or right handed?",
							"Am I a morning person? ",
							"What is my eye color?",
							"Do I have my own room?",
							"Do I like sports?",
							"Do I like to read?",
							"Do I like to swim?",
							"Do I like to draw?",
							"Do I exercise?",
							"When is the last time I cried?",
							"What is my hair color?",
							"How tall am I?"];
							
	// Pick a random question as an example
	var rand_question = random_questions[Math.floor(Math.random() * random_questions.length)];
	
	// Init the first random question
	$(".rand-question span").html(rand_question);
	
	// Init the global questions array
	var question_obj = {
		title: "",
		answers: []
	};
	
	var questions_array = [];
	var question_number = 1;
	
	// Add another question action
	$(document).on("click", ".btn-add-another-question", function(e) {
		
		e.preventDefault();
												
		// Get variables
		var current_question = $(".question-block.current");
		var current_question_number = parseInt(current_question.attr("data-number"));
		var current_title = current_question.find(".q-title-" + current_question_number);
							
		// Check the title of the current question
		if(current_title.val().length < 4) {
			
			showError('Oops. Your question should be at least 4 characters long...');
			
		} else {
			
			$("html, body").animate({ scrollTop: $('#main-content').offset().top - 20 }, "slow");
			
			$.toast({
				text: 'Queestion Added!',
				bgColor : '#27ae60',
				textColor : '#fff', 
				position : 'top-center'
			});
			
			var cpt_checked = 0;
			
			var answer_obj = {
				txt: "",
				good: false
			};
			
			var answers_array = [];
			
			// Loop through answers of this question
			$(current_question).find(".q-answer").each(function(index, elt) {
				
				var answer_txt = $(elt).find("input[type=text]").val();
				var answer_check = $(elt).find("input[type=checkbox]").is(":checked");
				
				if(answer_check) {
					cpt_checked++;
				}
				
				if(answer_txt != "") {
					answer_obj = {
						txt: answer_txt,
						good: answer_check
					};
					
					answers_array.push(answer_obj);
				}
				
			});
									
			if(answers_array.length < 2) {
				
				showError("Please write at least two answers for this question...");
				
			} else if(cpt_checked == 0) {
				
				showError("Please select at least one good answer...");
				
			} else {
				
				// Replace the current "btn-add-another-question" by another one
				current_question.find(".btn-add-another-question").html("Next <i class='fas fa-angle-right'></i>");
				current_question.find(".btn-add-another-question").removeClass("btn-add-another-question").addClass("btn-next-question"); 
				
				// Create the question with its answers
				question_obj = {
					id: question_number,
					title: current_title.val(),
					answers: answers_array
				};
				
				// Add to the questions array
				questions_array.push(question_obj);
			
				// New question ID
				var new_question = current_question_number+1;
											
				// Pick a random question as an example
				var rand_question = random_questions[Math.floor(Math.random() * random_questions.length)];
									
				var next_question_html = '<div class="question-block current" data-number="' + new_question + '">';
				next_question_html += '<div class="form-group form-centered">'; 
				next_question_html += '<label>Question #' + new_question + '</label>'; 
				next_question_html += '<input type="text" autocomplete="off" class="form-control q-title-' + new_question + '" name="q-title-' + new_question + '" placeholder="Write a question for your friends..." />'; 
				next_question_html += '<small class="form-text text-muted rand-question">Example : <span>' + rand_question + '</span></small>'; 
				next_question_html += '</div>';
				next_question_html += '<table class="table table-answers">'; 
				next_question_html += '<tr><th>Answers</th><th>Correct?</th></tr>';
				next_question_html += '<tr class="q-answer">'; 
				next_question_html += '<td>'; 
				next_question_html += '<input type="text" autocomplete="off" class="form-control q-title-' + new_question + '-a-title-1" name="q-title-' + new_question + '-a-title-1" placeholder="Write answer 1" />'; 
				next_question_html += '<div align="left">'; 
				next_question_html += '<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer must be set</small>'; 
				next_question_html += '</div>'; 
				next_question_html += '</td>'; 
				next_question_html += '<td>'; 
				next_question_html += '<label class="switch">'; 
				next_question_html += '<input checked="checked" class="q-title-' + new_question + '-a-good-1" name="q-title-' + new_question + '-a-good-1" type="checkbox">'; 
				next_question_html += '<span class="slider round"></span>'; 
				next_question_html += '</label>'; 
				next_question_html += '</td>'; 
				next_question_html += '</tr>'; 
				next_question_html += '<tr class="q-answer">'; 
				next_question_html += '<td>'; 
				next_question_html += '<input type="text" autocomplete="off" class="form-control q-title-' + new_question + '-a-title-2" name="q-title-' + new_question + '-a-title-2" placeholder="Write answer 2" />'; 
				next_question_html += '<div align="left">'; 
				next_question_html += '<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer must be set</small>'; 
				next_question_html += '</div>'; 
				next_question_html += '</td>'; 
				next_question_html += '<td>'; 
				next_question_html += '<label class="switch">'; 
				next_question_html += '<input class="q-title-' + new_question + '-a-good-2" name="q-title-' + new_question + '-a-good-2" type="checkbox">'; 
				next_question_html += '<span class="slider round"></span>'; 
				next_question_html += '</label>'; 
				next_question_html += '</td>'; 
				next_question_html += '</tr>';
				next_question_html += '<tr class="q-answer">'; 
				next_question_html += '<td>'; 
				next_question_html += '<input type="text" autocomplete="off" class="form-control q-title-' + new_question + '-a-title-3" name="q-title-' + new_question + '-a-title-3" placeholder="Write answer 3" />'; 
				next_question_html += '<div align="left"> <small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer is optional</small> </div>'; 
				next_question_html += '</td>'; 
				next_question_html += '<td>'; 
				next_question_html += '<label class="switch">'; 
				next_question_html += '<input class="q-title-' + new_question + '-a-good-3" name="q-title-' + new_question + '-a-good-3" type="checkbox">'; 
				next_question_html += '<span class="slider round"></span>'; 
				next_question_html += '</label>'; 
				next_question_html += '</td>'; 
				next_question_html += '</tr>'; 
				next_question_html += '<tr class="q-answer">'; 
				next_question_html += '<td>'; 
				next_question_html += '<input type="text" autocomplete="off" class="form-control q-title-' + new_question + '-a-title-4" name="q-title-' + new_question + '-a-title-4" placeholder="Write answer 4" />'; 
				next_question_html += '<div align="left">'; 
				next_question_html += '<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer is optional</small>'; 
				next_question_html += '</div>'; 
				next_question_html += '</td>'; 
				next_question_html += '<td>'; 
				next_question_html += '<label class="switch">'; 
				next_question_html += '<input class="q-title-' + new_question + '-a-good-4" name="q-title-' + new_question + '-a-good-4" type="checkbox">'; 
				next_question_html += '<span class="slider round"></span>'; 
				next_question_html += '</label>'; 
				next_question_html += '</td>'; 
				next_question_html += '</tr>'; 
				next_question_html += '</table>'; 
				next_question_html += '<div class="block-add-question">';
				next_question_html += '<a class="btn btn-sm btn-primary btn-prev-question" href="#"><i class="fas fa-angle-left"></i> Prev</a>';
				next_question_html += ' <a class="btn btn-sm btn-primary btn-add-another-question" href="#">Add Question <i class="fas fa-angle-right"></i></a>'; 
				next_question_html += '</div>';
				next_question_html += '</div>';

				// Hide the current question
				current_question.removeClass("current");
				
				// Add the new question
				current_question.after(next_question_html);
				
				// Increase page number
				question_number++;
				
				$(".quiz-questions-alert b").html(question_number-1);
			
			}
		
		}
		
	});
	
	// Click to next question (update the actual one)
	$(document).on("click", ".btn-next-question", function(e) {
		
		e.preventDefault();
											
		// Get variables
		var current_question = $(".question-block.current");
		var current_question_number = parseInt(current_question.attr("data-number"));
		var current_title = current_question.find(".q-title-" + current_question_number);
							
		// Check the title of the current question
		if(current_title.val().length < 4) {
			
			showError('Oops. Your question should be at least 4 characters long...');
			
		} else {
			
			var cpt_checked = 0;
			
			var answer_obj = {
				txt: "",
				good: false
			};
			
			var answers_array = [];
			
			// Loop through answers of this question
			$(current_question).find(".q-answer").each(function(index, elt) {
				
				var answer_txt = $(elt).find("input[type=text]").val();
				var answer_check = $(elt).find("input[type=checkbox]").is(":checked");
				
				if(answer_check) {
					cpt_checked++;
				}
				
				if(answer_txt != "") {
					answer_obj = {
						txt: answer_txt,
						good: answer_check
					};
					
					answers_array.push(answer_obj);
				}
				
			});
									
			if(answers_array.length < 2) {
				
				showError("Please write at least two answers for this question...");
				
			} else if(cpt_checked == 0) {
				
				showError("Please select at least one good answer...");
				
			} else {
				
				// Create the question with its answers
				question_obj = {
					id: question_number,
					title: current_title.val(),
					answers: answers_array
				};
				
				// Update the question
				questions_array[current_question_number] = question_obj;
				
				// Hide the current question
				current_question.removeClass("current");
				
				var next_question_number = current_question_number+1;
				
				// Show the next question
				$(".question-block[data-number=" + next_question_number + "]").addClass("current");
				
			}
			
		}
		
	});
	
	// Click to show previous question
	$(document).on("click", ".btn-prev-question", function(e) {
		
		e.preventDefault();
							
		var current_question = $(".question-block.current");
		var current_question_number = parseInt(current_question.attr("data-number"));
		
		current_question.removeClass("current");
		
		var prev_number = current_question_number-1;
		
		$(".question-block[data-number=" + prev_number + "]").addClass("current");
		
	});
	
	$(".btn-next-qcreator").click(function(e) {
		
		e.preventDefault();
		
		var title = $(".qcreator-part-1 .title").val();
		
		// Little form check...
		if(title.length < 3) {
			
			showError('Oops. Your title should be at least 3 characters long...');
			
		} else {
			
			$("html, body").animate({ scrollTop: $('#main-content').offset().top - 20 }, "slow");
			
			
			$(".qcreator-part-1").hide();
			$(".qcreator-part-2").fadeIn();
			$(".alert-create").hide();
			
		}
		
	});
	
	$(".btn-save-quiz").click(function(e) {
		
		e.preventDefault();
		
		$(this).addClass("disabled");
		
		var that = $(this);
			
							
		if(questions_array.length < 3) {
			
			showError("Please add at least 3 questions to your quiz...");
			that.removeClass("disabled");
			
		} else {
			
			var title = $(".qcreator-part-1 .title").val();
			
			$.ajax({
				url: "ajax/create-quiz.php",
				type: 'POST',
		        data: {
			        title: title,
			        questions_array: questions_array
		        },
		        dataType: "json",
		        success: function (data) {
			        
			        that.removeClass("disabled");
			        
			        if(data.status == 1) {
				        
				        var unique_id = data.unique_id;
				        
						$("#share").jsSocials({
				            shares: [{ share: "facebook", label: "Share on Facebook", logo: "fab fa-facebook", url: url + "/quiz.php?id=" + unique_id}]
				        });
				        
				        $("#quiz-link").val(url + "/quiz.php?id=" + unique_id);
				        
				        $(".qcreator-part-2").hide();
				        $(".qcreator-part-3").fadeIn();
				        
				        if(data.test_mode == 1) {
					        
					        $.toast({
								text: data.error,
								bgColor : '#e74c3c',
								textColor : '#fff', 
								position : 'top-right',
								hideAfter: 20000
							});
							
							$("#quiz-link").val("NO LINK IN DEMO MODE");
					        
				        }
				        
				        
			        } else {
				        showError(data.error);
				        that.removeClass("disabled");
			        }
			        
			    }
			});
			
		}
		
	});
	
	function showError(msg) {
		$.toast({
			text: msg,
			bgColor : '#e74c3c',
			textColor : '#fff', 
			position : 'top-right'
		});
	}
	
});